clear all;
close all;
clc;

% define the global variable
global max  centx centy p1 p2 p12 p21 root wx ax cx wy ay cy  h ar
global zx px kx zy py ky 
global uxsave uysave tsave

uxsave=[]; uysave=[]; tsave=[];

%Nonlinear map parameters
max = 1;            % max value of nonlinear map
centx = -1;          % x-coordinate of center of nonlinear map
centy = -1;          % y-coordinate of center of nonlinear map    
p1 = 1;             % values in Hessian (P)
p2 = 1/2;   
p12 = 0;
p21 = 0;
root = 1;           % can be used to spread map
    
% Extremum Seeking parameters
wx = 30;            % x-loop perturbation frequency
ax = .05;           % x-loop perturbation amplitude
cx = 20;            % x-loop gain

wy = wx;            % y-loop perturbation frequency
ay = ax;           % y-loop perturbation amplitude
cy = cx;            % y-loop gain

% PD compensator
zx=-3;              % x-loop zeros
px=-6;              % x-loop poles
kx=10;               % x-loop gains

zy=zx;              % y-loop zeros
py=px;              % y-loop poles
ky=kx;              % y-loop gains

% filter
h=1;

% disturbance amplitdue
ar=0;


% simulation
t0=0;  % start time
t1=50;  % end time

%initial condition of the state 
x0=[1,1,0,0,0,0,0];   

% solving the ode
tspan=[t0 t1];  
rand('seed',0)
myoptions = odeset('OutputFcn','odeplot');
[t, x] = ode23('doublepointmass_derivatives', tspan, x0, myoptions);
%[t,x]=ode23('doublepointmass_derivatives',tspan,x0);    
    
for i=1:length(t)
    idx = find(tsave-t(i)==0);
    ux(i)=uxsave(idx(length(idx)));
    uy(i)=uysave(idx(length(idx)));
end;

% trajectory of the states
xp=x(:,1);
yp=x(:,2);
J=max./(1+p1.*(xp-centx).^2+p2.*(yp-centy).^2).^(root);

figure 
plot(t,J,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('output','FontSize',18,'FontWeight','bold');
title('Objective Function','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 

figure 
plot(xp,yp,'r','LineWidth',3);
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 

